%% EJEMPLO 11: DESINTEGRACION RADIOACTIVA
clear;

N0=1e5; % Nmero inicial de ncleos
lambda=0.01; % Constante de desintegracion =1/tau, siendo tau el tiempo de vida del ncleo

N=N0; Dt=1; t=0;
file=fopen('desintegracion.dat','w');
while N>0
    DN=0;
    for i=1:N
        if rand<lambda
            DN=DN+1;
        end
    end
    t=t+Dt;
    N=N-DN;
    fprintf(file,'%d\t%f\n',t,N);
end
fprintf('\n Datos salvados en desintegracion.dat \n\n');
fclose(file);
%% Representacin grfica
data=load('desintegracion.dat');
semilogy(data(:,1),data(:,2)); grid on;
xlabel('tiempo'); ylabel('Nmeros de ncleos, N');
title('DESINTEGRACIN RADIOACTIVA');
%% Sonido de la desintegracin
% (Recuerda a un contador Geiger
% Ojo: la secuencia es muy corta
wavplay(data(:,2),44100) % FS=4.410kHz